<?php

/**
 * Plugin Name: Shipex AI
 * Plugin URI: https://shipex.cl
 * Description: Asistente virtual con inteligencia artificial para mejorar la experiencia en WooCommerce.
 * Version: 1.0
 * Author: Shipex AI
 * Author URI: https://shipex.cl
 * License: GPL2
 */

if (!defined('ABSPATH')) {
    exit; // Evita el acceso directo
}

// Verificar si WooCommerce está activo
add_action('plugins_loaded', function () {
    if (!class_exists('WooCommerce')) {
        add_action('admin_notices', function () {
            echo '<div class="error"><p><strong>AsistenteVirtualWooCommerce:</strong> WooCommerce debe estar activado.</p></div>';
        });
        return;
    }

    // Cargar archivos del plugin con verificación de existencia
    $admin_settings_path = plugin_dir_path(__FILE__) . 'includes/admin-settings.php';
    $functions_path = plugin_dir_path(__FILE__) . 'includes/functions.php';
    $logs_path = plugin_dir_path(__FILE__) . 'includes/logs.php';
    $starter_ai_path = plugin_dir_path(__FILE__) . 'includes/starter-ai.php';

    if (file_exists($admin_settings_path)) {
        require_once $admin_settings_path;
    } else {
        error_log('Error: No se encontró admin-settings.php en ' . $admin_settings_path);
    }

    if (file_exists($functions_path)) {
        require_once $functions_path;
    } else {
        error_log('Error: No se encontró functions.php en ' . $functions_path);
    }

    if (file_exists($logs_path)) {
        require_once $logs_path;
    } else {
        error_log('Error: No se encontró logs.php en ' . $logs_path);
    }

    if (file_exists($starter_ai_path)) {
        require_once $starter_ai_path;
    } else {
        error_log('Error: No se encontró starter-ai.php en ' . $logs_path);
    }
});

// Activar el registro de incidencias al activar el plugin
function avw_activar_registro_de_incidencias()
{
    if (class_exists('WC_Logger')) {
        $logger = wc_get_logger();
        $logger->info('El registro de incidencias ha sido activado por AsistenteVirtualWooCommerce.', array('source' => 'asistentevirtualwoocommerce'));
    }
}
register_activation_hook(__FILE__, 'avw_activar_registro_de_incidencias');

// Forzar la activación del registro de incidencias en WooCommerce
add_action('admin_init', function () {
    if (!get_option('woocommerce_logging_enabled')) {
        update_option('woocommerce_logging_enabled', 'yes');
    }
});

require_once plugin_dir_path(__FILE__) . 'includes/checkout_adaptacion_shipex.php';
