<?php

if (!defined('ABSPATH')) {
    exit;
}

class StarterAI_Config
{

    public static function get_enable_logs()
    {
        return true; // Habilitar o deshabilitar el envío de logs
    }

    public static function get_api_token()
    {
        $api_token = get_api_token();
        error_log("🔍 El API Token obtenido es: " . $api_token);
    }

    // 🔹 URLs de cada evento con el token concatenado
    public static function get_api_endpoint($event)
    {
        $api_token = get_option('avw_api_token', ''); // Obtener el token de configuración

        $endpoints = [
            'cart_update'  => 'https://backend.shipex.ai/api/wc/create-or-update-carts/',
            'checkout'     => 'https://backend.shipex.ai/api/wc/create-or-update-checkout/',
            'order_create' => 'https://backend.shipex.ai/api/wc/create-or-update-order/'
        ];

        return isset($endpoints[$event]) && !empty($api_token)
            ? $endpoints[$event] . $api_token
            : null;
    }
}
