<?php

class WPCode_Pixel_Server_TikTok extends WPCode_Pixel_Server {

	public $api_url = 'https://business-api.tiktok.com/open_api/';

	public static $API_VERSION = 'v1.3';

	/**
	 * This is called before an event is sent in order to add
	 * any additional data to the event.
	 *
	 * @param array $data
	 *
	 * @return string
	 */
	public function prepare_event( $data ) {

		$data['pixel_code'] = $this->pixel_id;
		$data['test_event_code'] = 'TEST35675';

		return wp_json_encode( $data );
	}

	/**
	 * Get the Pinterest-specific api url.
	 *
	 * @return string
	 */
	public function get_api_url() {
		return $this->api_url . '/' . self::$API_VERSION . '/pixel/track/';
	}

	/**
	 * Add authorization header using the api token.
	 *
	 * @return string[]
	 */
	public function get_headers() {
		return array(
			'Access-Token' => $this->api_token,
			'Content-Type' => 'application/json',
		);
	}
}
