<?php 
/*** Redux Framework ***/
require_once get_template_directory().'/admin/init.php';

/*** Theme Framework ***/
require_once get_template_directory().'/framework/init.php';

/* Add Qurate Tag in Thank You page */
add_action('woocommerce_thankyou', 'custom_thankyou_html_qurate');

function custom_thankyou_html_qurate($order_id) {
    echo '<qurate-slider></slider-slider>';
}

// Mostrar productos opcionales
function extra_products_html() {
    // Solo muestra los accesorios si no se han renderizado antes
    if (did_action('woocommerce_before_add_to_cart_quantity') || did_action('woocommerce_before_variations_form')) {
        return; // Evita duplicar
    }
    ?>
    <div class="ts-extra-products-wrapper">
        <div class="heading">Accesorios Adicionales</div>
        <div class="items">
            <!-- Aquí puedes insertar el HTML o lógica de tus productos opcionales -->
            <div class="item">
                <div class="product-image-meta">
                    <div class="image">
                        <img src="https://example.com/tu-imagen.jpg" alt="Producto opcional">
                    </div>
                    <div class="meta">
                        <span>Nombre del accesorio</span>
                        <span>$10.000</span>
                    </div>
                </div>
                <label>
                    <input type="checkbox" class="ts-extra-products-checkbox">
                    <span data-checked="Seleccionado" data-unchecked="Seleccionar">Seleccionar</span>
                </label>
            </div>
        </div>
    </div>
    <?php
}

// Reorganizar ganchos para evitar duplicaciones
add_action('woocommerce_before_variations_form', function() {
    if (is_product() && has_term('variable', 'product_type')) { // Solo para productos variables
        // Mostrar las opciones de color antes
        do_action('woocommerce_before_variations_table');
        // Agregar los productos opcionales después
        extra_products_html();
    }
}, 10);

add_action('woocommerce_before_add_to_cart_quantity', function() {
    if (is_product() && has_term('simple', 'product_type')) { // Solo para productos simples
        extra_products_html();
    }
}, 10);


?>
