<?php

if (!defined('ABSPATH')) {
    exit;
}

require_once plugin_dir_path(__FILE__) . 'StarterAI_Config.php';

class StarterAI_Logger
{

    public static function send_data_to_endpoint($event, $data)
    {
        if (!StarterAI_Config::get_enable_logs()) {
            error_log("❌ Envío de logs deshabilitado.");
            return;
        }

        $endpoint_url = StarterAI_Config::get_api_endpoint($event);

        if (empty($endpoint_url)) {
            error_log("❌ No hay una URL definida para el evento: " . $event);
            return;
        }

        $args = [
            'method'    => 'POST',
            'body'      => json_encode($data),
            'headers'   => [
                'Content-Type'  => 'application/json',
            ],
            'timeout'   => 30,
        ];

        $response = wp_remote_post($endpoint_url, $args);

       // Manejo de errores en la solicitud
        if (is_wp_error($response)) {
            $error_message = $response->get_error_message();
            error_log("❌ Error al enviar datos al endpoint ($event): " . $error_message);
            return;
        }

        // Capturar el código de respuesta y el cuerpo de la respuesta
        $http_code = wp_remote_retrieve_response_code($response);
        $response_body = wp_remote_retrieve_body($response);

        // Registrar la respuesta en el log
        error_log("✅ Datos enviados al endpoint ($event): " . json_encode($data));
        error_log("📩 Respuesta del endpoint ($event) - Código: " . $http_code . " - Cuerpo: " . $response_body);
        }
}
