<?php

if (!defined('ABSPATH')) {
    exit;
}

// Agregar menú en WooCommerce
function avw_agregar_submenu() {
    add_submenu_page(
        'woocommerce',
        'Asistente Virtual WooCommerce',
        'Shipex AI',
        'manage_woocommerce',
        'asistentevirtualwoocommerce',
        'avw_pagina_configuracion'
    );
}
add_action('admin_menu', 'avw_agregar_submenu');

// Página de configuración
function avw_pagina_configuracion() {
    ?>
    <div class="wrap">
        <h1>Asistente Virtual WooCommerce</h1>
        <form method="post" action="options.php">
            <?php
                settings_fields('avw_configuracion_grupo');
                do_settings_sections('asistentevirtualwoocommerce');
                submit_button();
            ?>
        </form>
    </div>
    <?php
}

// Registrar configuraciones
function avw_registrar_ajustes() {
    register_setting('avw_configuracion_grupo', 'avw_api_token');
    add_settings_section('avw_seccion', 'Configuración General', null, 'asistentevirtualwoocommerce');
    add_settings_field('avw_api_token', 'API Token', 'avw_campo_api_token', 'asistentevirtualwoocommerce', 'avw_seccion');
}
add_action('admin_init', 'avw_registrar_ajustes');

function avw_campo_api_token() {
    $valor = esc_attr(get_option('avw_api_token', ''));
    echo '<input type="text" name="avw_api_token" value="' . $valor . '" class="regular-text">';
}

// Agregar opción de configuración para habilitar logs
function avw_registrar_configuracion_logs() {
    register_setting('avw_configuracion_grupo', 'avw_habilitar_logs');
    add_settings_field('avw_habilitar_logs', 'Habilitar Logs', 'avw_campo_logs', 'asistentevirtualwoocommerce', 'avw_seccion');
}
add_action('admin_init', 'avw_registrar_configuracion_logs');

function avw_campo_logs() {
    $valor = get_option('avw_habilitar_logs', 'no');
    echo '<input type="checkbox" name="avw_habilitar_logs" value="yes" ' . checked($valor, 'yes', false) . '> Activar Registro de Logs';
}

