# Security

This plugin has been designed with security in mind. However, it is important to remember that no software is completely secure and there are always risks associated with using any software, including this plugin.

## Known Vulnerabilities

If you have discovered a security vulnerability in this plugin, please do the following:

1. **Do not disclose the vulnerability publicly**. This could put website users at risk and allow attackers to exploit the vulnerability.
2. **[Contact the plugin developer](ryan.hungate@contractors.mailchimp.com)**. The developer will be able to provide guidance on how to report the vulnerability and work with you to fix it.
3. **Report the vulnerability to the WordPress Plugin Directory**. The WordPress Plugin Directory maintains a list of known vulnerabilities for all plugins hosted on their platform. Reporting the vulnerability to them will help ensure that other plugin users are aware of the issue and can take appropriate precautions.

## Recommended Practices

To ensure the security of your website and protect against potential vulnerabilities, we recommend the following best practices:

- Keep the plugin up to date. Plugin developers often release updates to fix security vulnerabilities and other issues. By keeping the plugin up to date, you can ensure that your website is using the most secure version of the plugin.
- Follow WordPress security best practices. WordPress has a number of security best practices that can help protect your website against potential vulnerabilities. These include using strong passwords, keeping your WordPress core, themes, and plugins up to date, and using a security plugin.
- Use caution when installing plugins. Not all plugins are created equal, and some may have security vulnerabilities or be poorly maintained. Be sure to research a plugin before installing it, and only install plugins from reputable sources.

## Disclaimer

This plugin is provided "as is" without warranty of any kind, either expressed or implied. The plugin developer will not be held responsible for any damages resulting from the use of this plugin. It is the responsibility of the user to ensure that the plugin is used in a secure manner and to take appropriate precautions to protect their website and data.
