<?php
  class EmergencyRate {
    public $region_id = '';
    public $price = '';
    public $communes = array(
      701 => 8,
      702 => 8,
      703 => 8,
      704 => 8,
      705 => 6,
      706 => 14,
      707 => 4,
      708 => 8,
      709 => 5,
      710 => 5,
      711 => 14,
      712 => 14,
      713 => 14,
      714 => 6,
      715 => 9,
      4 => 15,
      397 => 13,
      451 => 5,
      343 => 13,
      716 => 8,
      717 => 5,
      718 => 13,
      719 => 10,
      720 => 4,
      721 => 13,
      722 => 4,
      723 => 7,
      724 => 5,
      725 => 5,
      726 => 8,
      727 => 13,
      728 => 8,
      729 => 6,
      730 => 2,
      731 => 15,
      733 => 15,
      734 => 4,
      735 => 4,
      736 => 8,
      737 => 4,
      738 => 15,
      739 => 2,
      740 => 6,
      741 => 4,
      742 => 8,
      743 => 8,
      747 => 8,
      748 => 4,
      749 => 13,
      750 => 11,
      641 => 15,
      751 => 8,
      752 => 6,
      753 => 11,
      754 => 11,
      755 => 11,
      756 => 8,
      757 => 11,
      759 => 10,
      760 => 8,
      761 => 15,
      762 => 10,
      763 => 8,
      764 => 2,
      765 => 9,
      692 => 4,
      321 => 13,
      48 => 5,
      375 => 13,
      413 => 11,
      449 => 13,
      365 => 13,
      374 => 13,
      337 => 13,
      348 => 3,
      367 => 13,
      382 => 13,
      502 => 14,
      732 => 4,
      184 => 16,
      14 => 2,
      165 => 8,
      210 => 9,
      417 => 7,
      427 => 12,
      616 => 5,
      633 => 10,
      678 => 9,
      697 => 4,
      758 => 7,
      61 => 5,
      62 => 5,
      64 => 5,
      65 => 5,
      66 => 5,
      68 => 5,
      72 => 5,
      73 => 5,
      75 => 5,
      79 => 5,
      80 => 5,
      81 => 5,
      84 => 6,
      85 => 6,
      69 => 5,
      70 => 5,
      71 => 5,
      400 => 1,
      435 => 13,
      98 => 6,
      312 => 13,
      315 => 13,
      501 => 6,
      237 => 14,
      330 => 13,
      331 => 13,
      339 => 13,
      492 => 2,
      494 => 15,
      245 => 10,
      495 => 8,
      324 => 13,
      325 => 13,
      497 => 1,
      247 => 10,
      499 => 3,
      309 => 13,
      311 => 13,
      304 => 13,
      504 => 7,
      421 => 5,
      77 => 5,
      87 => 6,
      88 => 6,
      90 => 6,
      91 => 6,
      93 => 6,
      100 => 6,
      101 => 6,
      102 => 6,
      105 => 6,
      106 => 6,
      107 => 6,
      108 => 6,
      109 => 6,
      112 => 6,
      113 => 6,
      115 => 6,
      116 => 7,
      118 => 7,
      103 => 6,
      119 => 7,
      121 => 7,
      7 => 1,
      122 => 7,
      123 => 7,
      124 => 7,
      125 => 7,
      127 => 7,
      128 => 7,
      131 => 7,
      132 => 7,
      133 => 7,
      134 => 7,
      135 => 7,
      136 => 7,
      137 => 7,
      138 => 7,
      141 => 7,
      142 => 7,
      143 => 7,
      146 => 8,
      144 => 7,
      145 => 7,
      147 => 8,
      148 => 8,
      150 => 8,
      151 => 8,
      152 => 8,
      154 => 8,
      155 => 8,
      590 => 9,
      8 => 1,
      9 => 1,
      10 => 1,
      11 => 1,
      12 => 2,
      13 => 2,
      15 => 2,
      16 => 2,
      18 => 2,
      19 => 2,
      20 => 2,
      21 => 3,
      22 => 3,
      23 => 3,
      24 => 3,
      29 => 3,
      30 => 4,
      31 => 4,
      32 => 4,
      35 => 4,
      36 => 4,
      37 => 4,
      38 => 4,
      39 => 4,
      40 => 4,
      43 => 4,
      44 => 4,
      45 => 5,
      240 => 14,
      266 => 10,
      306 => 13,
      318 => 13,
      336 => 13,
      340 => 13,
      179 => 16,
      46 => 5,
      342 => 13,
      180 => 16,
      181 => 16,
      53 => 5,
      54 => 5,
      560 => 6,
      55 => 5,
      588 => 10,
      646 => 8,
      47 => 5,
      49 => 5,
      50 => 5,
      52 => 5,
      56 => 5,
      139 => 7,
      58 => 5,
      59 => 5,
      295 => 13,
      60 => 5,
      67 => 5,
      74 => 5,
      76 => 5,
      82 => 5,
      83 => 6,
      92 => 6,
      94 => 6,
      96 => 6,
      97 => 6,
      308 => 13,
      229 => 9,
      110 => 6,
      117 => 7,
      120 => 7,
      129 => 7,
      231 => 9,
      130 => 7,
      126 => 7,
      153 => 8,
      157 => 8,
      158 => 8,
      160 => 8,
      161 => 8,
      156 => 8,
      162 => 8,
      166 => 8,
      167 => 8,
      168 => 8,
      169 => 8,
      170 => 8,
      171 => 8,
      172 => 8,
      174 => 8,
      175 => 8,
      176 => 8,
      173 => 8,
      177 => 8,
      178 => 8,
      200 => 9,
      202 => 9,
      203 => 9,
      204 => 9,
      206 => 9,
      207 => 9,
      208 => 9,
      209 => 9,
      211 => 9,
      212 => 9,
      213 => 9,
      447 => 11,
      456 => 5,
      493 => 2,
      514 => 5,
      533 => 4,
      214 => 9,
      192 => 16,
      205 => 9,
      303 => 13,
      476 => 5,
      57 => 5,
      1 => 15,
      2 => 15,
      3 => 15,
      293 => 12,
      5 => 1,
      25 => 3,
      26 => 3,
      27 => 3,
      41 => 4,
      86 => 6,
      335 => 13,
      323 => 13,
      434 => 6,
      249 => 10,
      372 => 13,
      33 => 4,
      163 => 8,
      573 => 5,
      215 => 9,
      216 => 9,
      217 => 9,
      218 => 9,
      219 => 9,
      220 => 9,
      221 => 9,
      222 => 9,
      78 => 5,
      89 => 6,
      326 => 13,
      223 => 9,
      224 => 9,
      225 => 9,
      226 => 9,
      227 => 9,
      228 => 9,
      496 => 8,
      232 => 14,
      233 => 14,
      164 => 9,
      291 => 12,
      292 => 12,
      294 => 12,
      234 => 14,
      235 => 14,
      236 => 14,
      51 => 5,
      238 => 14,
      239 => 14,
      42 => 4,
      242 => 14,
      243 => 14,
      244 => 10,
      246 => 10,
      248 => 10,
      250 => 10,
      251 => 10,
      252 => 10,
      253 => 10,
      254 => 10,
      255 => 10,
      256 => 10,
      257 => 10,
      258 => 10,
      259 => 10,
      260 => 10,
      261 => 10,
      262 => 10,
      263 => 10,
      264 => 10,
      265 => 10,
      267 => 10,
      268 => 10,
      269 => 10,
      271 => 10,
      272 => 10,
      273 => 10,
      274 => 11,
      275 => 11,
      277 => 11,
      278 => 11,
      279 => 11,
      281 => 11,
      282 => 11,
      283 => 11,
      285 => 12,
      286 => 12,
      287 => 8,
      289 => 12,
      290 => 12,
      299 => 13,
      297 => 13,
      298 => 13,
      190 => 16,
      301 => 13,
      302 => 13,
      305 => 13,
      307 => 13,
      310 => 13,
      313 => 13,
      314 => 13,
      316 => 13,
      319 => 13,
      320 => 13,
      322 => 13,
      327 => 13,
      333 => 13,
      334 => 13,
      182 => 16,
      183 => 16,
      185 => 16,
      186 => 16,
      187 => 16,
      188 => 16,
      189 => 16,
      201 => 9,
      344 => 13,
      345 => 13,
      346 => 13,
      347 => 5,
      350 => 8,
      357 => 6,
      191 => 16,
      193 => 16,
      194 => 16,
      195 => 16,
      196 => 16,
      197 => 16,
      198 => 16,
      199 => 16,
      363 => 5,
      366 => 13,
      368 => 13,
      369 => 13,
      370 => 13,
      371 => 13,
      373 => 13,
      391 => 13,
      392 => 13,
      393 => 13,
      396 => 13,
      401 => 1,
      402 => 4,
      376 => 13,
      377 => 13,
      378 => 13,
      380 => 13,
      381 => 13,
      383 => 13,
      384 => 13,
      385 => 13,
      386 => 13,
      387 => 13,
      388 => 13,
      389 => 13,
      390 => 5,
      399 => 2,
      404 => 6,
      405 => 11,
      406 => 11,
      407 => 5,
      408 => 1,
      410 => 10,
      412 => 5,
      414 => 5,
      416 => 7,
      423 => 8,
      424 => 10,
      425 => 4,
      426 => 4,
      428 => 8,
      429 => 12,
      430 => 2,
      431 => 4,
      574 => 5,
      432 => 6,
      433 => 13,
      587 => 2,
      436 => 6,
      437 => 10,
      438 => 2,
      439 => 3,
      441 => 5,
      444 => 3,
      445 => 10,
      446 => 11,
      448 => 2,
      450 => 15,
      452 => 7,
      453 => 6,
      454 => 8,
      455 => 9,
      457 => 6,
      458 => 4,
      459 => 9,
      460 => 14,
      461 => 11,
      462 => 10,
      463 => 6,
      464 => 7,
      465 => 12,
      466 => 8,
      467 => 3,
      338 => 13,
      468 => 9,
      469 => 15,
      470 => 8,
      471 => 10,
      472 => 4,
      473 => 1,
      474 => 3,
      475 => 2,
      477 => 10,
      478 => 8,
      479 => 4,
      480 => 12,
      481 => 10,
      482 => 4,
      483 => 4,
      484 => 8,
      485 => 14,
      486 => 10,
      487 => 8,
      488 => 4,
      498 => 9,
      500 => 15,
      503 => 7,
      505 => 6,
      507 => 7,
      508 => 14,
      509 => 15,
      510 => 10,
      511 => 8,
      512 => 4,
      513 => 7,
      515 => 6,
      516 => 13,
      517 => 4,
      518 => 6,
      519 => 5,
      520 => 4,
      522 => 4,
      523 => 4,
      524 => 5,
      525 => 5,
      526 => 4,
      527 => 4,
      528 => 10,
      529 => 10,
      530 => 15,
      531 => 3,
      532 => 13,
      534 => 11,
      535 => 7,
      536 => 4,
      537 => 4,
      539 => 5,
      540 => 4,
      541 => 5,
      542 => 4,
      543 => 2,
      544 => 13,
      545 => 8,
      546 => 4,
      547 => 10,
      548 => 14,
      549 => 4,
      550 => 8,
      551 => 10,
      552 => 4,
      553 => 9,
      554 => 7,
      555 => 5,
      556 => 14,
      557 => 1,
      558 => 7,
      559 => 3,
      561 => 4,
      562 => 1,
      563 => 4,
      564 => 4,
      566 => 13,
      567 => 13,
      569 => 6,
      570 => 11,
      571 => 1,
      572 => 9,
      575 => 10,
      576 => 8,
      577 => 6,
      578 => 4,
      579 => 5,
      580 => 5,
      582 => 6,
      583 => 4,
      584 => 4,
      585 => 8,
      586 => 5,
      589 => 5,
      591 => 4,
      592 => 10,
      593 => 9,
      594 => 1,
      595 => 8,
      596 => 4,
      597 => 10,
      598 => 14,
      599 => 6,
      600 => 7,
      601 => 13,
      602 => 7,
      603 => 8,
      604 => 4,
      605 => 9,
      606 => 6,
      607 => 13,
      608 => 5,
      609 => 7,
      610 => 4,
      611 => 10,
      612 => 9,
      613 => 1,
      614 => 10,
      615 => 5,
      619 => 10,
      620 => 14,
      621 => 11,
      622 => 8,
      623 => 4,
      624 => 8,
      625 => 1,
      626 => 15,
      627 => 8,
      628 => 12,
      629 => 4,
      630 => 5,
      631 => 4,
      632 => 8,
      634 => 14,
      635 => 14,
      636 => 8,
      637 => 11,
      638 => 7,
      639 => 8,
      640 => 10,
      642 => 3,
      643 => 10,
      644 => 4,
      645 => 4,
      647 => 7,
      648 => 2,
      649 => 14,
      650 => 10,
      651 => 10,
      652 => 4,
      653 => 6,
      654 => 5,
      655 => 10,
      656 => 4,
      657 => 10,
      658 => 5,
      659 => 4,
      660 => 9,
      661 => 8,
      662 => 4,
      663 => 15,
      664 => 8,
      665 => 6,
      666 => 5,
      667 => 10,
      668 => 10,
      669 => 8,
      670 => 10,
      671 => 6,
      672 => 10,
      673 => 6,
      674 => 11,
      675 => 4,
      676 => 11,
      677 => 12,
      679 => 12,
      680 => 11,
      681 => 4,
      682 => 12,
      683 => 4,
      684 => 10,
      685 => 8,
      686 => 5,
      687 => 12,
      688 => 8,
      689 => 14,
      690 => 11,
      691 => 4,
      693 => 9,
      694 => 10,
      695 => 9,
      696 => 14,
      698 => 2,
      699 => 8,
      700 => 5,
      270 => 10,
      328 => 13,
      159 => 8,
      581 => 4,
      538 => 10,
      565 => 2,
      230 => 9,
      241 => 14,
      114 => 6,
      618 => 5,
      356 => 10,
      284 => 12,
      489 => 8,
      490 => 14,
      491 => 6,
      329 => 13,
      398 => 13,
      300 => 13,
      317 => 13,
      296 => 13,
      506 => 4,
      140 => 7,
      521 => 13,
      744 => 9,
      745 => 10,
      746 => 8,
      379 => 13,
      440 => 4,
      442 => 4,
      394 => 13,
      395 => 13,
      443 => 5,
      568 => 4,
      6 => 1,
      364 => 13,
      28 => 3,
      354 => 6,
      418 => 5,
      352 => 6
    );


    public function __construct($region_id = '', $price = '') {
      $this->region_id = $region_id;
      $this->price = $price;
    }

    function getRegionId() {
      return $this->region_id;
    }

    function getPrice() {
      return $this->price;
    }

    static function deleteRates($wpdb) {
      $table  = "{$wpdb->prefix}shipit_emergency_rates";
      $wpdb->query("TRUNCATE TABLE $table");
    }

    function saveRate($wpdb) {
      $wpdb->insert("{$wpdb->prefix}shipit_emergency_rates", array(
        'region' => $this->getRegionId(),
        'price' => $this->getPrice(),
        'created_at' => date("Y-m-d H:i:s"),
      ));
    }

    function getRegionByCommune($communeId) {
      return $this->communes[$communeId];
    }

    function getEmergencyRate($wpdb, $communeId) {
      $regionId = $this->getRegionByCommune($communeId);
      $result = $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}shipit_emergency_rates WHERE region = {$regionId}" );
      if(isset($result[0]->price)) { 
        $emergencyRate = array(
          'prices' =>  [ array(
            'courier' => array(
              'name' => 'shipit'
            ),
            'name' => 'Despacho a domicilio',
            'price' => $result[0]->price,
            'days' => 1,
            'available_to_shipping' => true,
            'original_courier' => 'shipit',
            'is_payable' => '',
            'discount' => array(
              'tota' => 0,
              'original_price' => $result[0]->price,
              'shipment_discounts' => array()
            )
          )]
          );
      } else {
        $emergencyRate['prices'] = [];
      }

      return json_encode($emergencyRate);
    }

    function saveRequest($wpdb, $request) {
      $wpdb->insert('wp_shipit_rates_request', array(
        'request' => json_encode($request['parcel']),
      ));
    }

    function getPayloadRequest($wpdb, $limit) {
      return $wpdb->get_results( "SELECT * FROM {$wpdb->prefix}shipit_rates_request limit {$limit}" );
    }

    function deletePayloadLowerId($wpdb, $id) {
      return $wpdb->get_results( "DELETE FROM {$wpdb->prefix}shipit_rates_request where id <= {$id}" );
    }

    function getRangeId($payload) {
     $range_id = array();
     $range_id['min'] = $payload[0]['id'];
     $range_id['max'] = $payload[count($payload)]['id'];

     return $range_id;
    }

    function dequeue($wpdb, $limit, $headers, $base, $success_responses_code, $from) {
      $payload = array();
      $result = $this->getPayloadRequest($wpdb, $limit);
      if (count($result) > 0) {
        $client = new HttpClient($base . '/mixpanel/track', $headers);
        foreach ($result as $key => $value) {
          array_push($payload, $value->request);
        }
        $response = $client->post(['rate_payload' => $payload, 'from' => $from]);
        if (!in_array(wp_remote_retrieve_response_code($response), $success_responses_code)) {

        } else {
          $this->deletePayloadLowerId($wpdb, $value->id);

        }

      }

    }

  }
?>
