<?php

class WPCode_Pixel_Admin_Page_Pixel extends WPCode_Admin_Page_Pixel {

	/**
	 * Register hook on admin init just for this page.
	 *
	 * @return void
	 */
	public function page_hooks() {
		$this->process_message();
		add_action( 'admin_init', array( $this, 'submit_listener' ) );
	}

	/**
	 * Process messages specific to this page.
	 *
	 * @return void
	 */
	public function process_message() {
		if ( empty( $_GET['message'] ) ) {
			return;
		}
		$messages = array(
			1 => __( 'Settings updated.', 'wpcode-pixel' ),
			2 => __( 'We encountered an error saving your settings.', 'wpcode-pixel' ),
		);
		$message  = absint( $_GET['message'] );
		// phpcs:enable WordPress.Security.NonceVerification

		if ( ! isset( $messages[ $message ] ) ) {
			return;
		}

		if ( $message > 1 ) {
			$this->set_error_message( $messages[ $message ] );
		} else {
			$this->set_success_message( $messages[ $message ] );
		}

	}

	/**
	 * The Conversion Pixels page output.
	 * In the actual addon page wrap elements in a form as the lite plugin
	 * never needs an actual form.
	 *
	 * @return void
	 */
	public function output_content() {
		if ( method_exists( $this, 'output_view_' . $this->view ) ) {
			$this->adblocker_notice();
			?>
			<form action="<?php echo esc_url( $this->get_page_action_url() ); ?>" method="post">
				<?php
				call_user_func( array( $this, 'output_view_' . $this->view ) );
				?>
			</form>
			<?php
			$this->adblocker_notice_js();
		}
	}

	/**
	 * Listen for POSTed data and process it.
	 *
	 * @return void
	 */
	public function submit_listener() {

		// Don't allow users who can't change snippet output to save settings.
		if ( ! current_user_can( 'wpcode_activate_snippets' ) || ! isset( $_POST['wpcode-pixel-nonce'] ) ) {
			return;
		}

		if ( wp_verify_nonce( sanitize_key( $_POST['wpcode-pixel-nonce'] ), 'wpcode-save-facebook-pixel-data' ) ) {
			$facebook_pixel_id        = isset( $_POST['facebook_pixel_id'] ) ? sanitize_text_field( $_POST['facebook_pixel_id'] ) : '';
			$facebook_pixel_api_token = isset( $_POST['facebook_pixel_api_token'] ) ? sanitize_text_field( $_POST['facebook_pixel_api_token'] ) : '';
			$facebook_pixel_events    = isset( $_POST['facebook_pixel_events'] ) ? array_map( 'boolval', $_POST['facebook_pixel_events'] ) : array();

			wpcode()->settings->update_option( 'facebook_pixel_id', $facebook_pixel_id );
			wpcode()->settings->update_option( 'facebook_pixel_api_token', $facebook_pixel_api_token );
			wpcode()->settings->update_option( 'facebook_pixel_events', $facebook_pixel_events );
		}

		if ( wp_verify_nonce( sanitize_key( $_POST['wpcode-pixel-nonce'] ), 'wpcode-save-google-pixel-data' ) ) {
			$google_analytics_id = isset( $_POST['google_analytics_id'] ) ? sanitize_text_field( $_POST['google_analytics_id'] ) : '';
			$google_ads_id       = isset( $_POST['google_ads_id'] ) ? sanitize_text_field( $_POST['google_ads_id'] ) : '';
			$google_ads_label    = isset( $_POST['google_ads_label'] ) ? sanitize_text_field( $_POST['google_ads_label'] ) : '';
			$google_pixel_events = isset( $_POST['google_pixel_events'] ) ? array_map( 'boolval', $_POST['google_pixel_events'] ) : array();

			wpcode()->settings->update_option( 'google_analytics_id', $google_analytics_id );
			wpcode()->settings->update_option( 'google_ads_id', $google_ads_id );
			wpcode()->settings->update_option( 'google_ads_label', $google_ads_label );
			wpcode()->settings->update_option( 'google_pixel_events', $google_pixel_events );
		}

		if ( wp_verify_nonce( sanitize_key( $_POST['wpcode-pixel-nonce'] ), 'wpcode-save-pinterest-pixel-data' ) ) {
			$pinterest_id               = isset( $_POST['pinterest_id'] ) ? sanitize_text_field( $_POST['pinterest_id'] ) : '';
			$pinterest_ad_account_id    = isset( $_POST['pinterest_ad_account_id'] ) ? sanitize_text_field( $_POST['pinterest_ad_account_id'] ) : array();
			$pinterest_conversion_token = isset( $_POST['pinterest_conversion_token'] ) ? sanitize_text_field( $_POST['pinterest_conversion_token'] ) : array();
			$pinterest_pixel_events     = isset( $_POST['pinterest_pixel_events'] ) ? array_map( 'boolval', $_POST['pinterest_pixel_events'] ) : array();

			wpcode()->settings->update_option( 'pinterest_id', $pinterest_id );
			wpcode()->settings->update_option( 'pinterest_ad_account_id', $pinterest_ad_account_id );
			wpcode()->settings->update_option( 'pinterest_conversion_token', $pinterest_conversion_token );
			wpcode()->settings->update_option( 'pinterest_pixel_events', $pinterest_pixel_events );
		}

		if ( wp_verify_nonce( sanitize_key( $_POST['wpcode-pixel-nonce'] ), 'wpcode-save-tiktok-pixel-data' ) ) {
			$tiktok_pixel_id     = isset( $_POST['tiktok_pixel_id'] ) ? sanitize_text_field( $_POST['tiktok_pixel_id'] ) : '';
			$tiktok_access_token = isset( $_POST['tiktok_access_token'] ) ? sanitize_text_field( $_POST['tiktok_access_token'] ) : '';
			$tiktok_pixel_events = isset( $_POST['tiktok_pixel_events'] ) ? array_map( 'boolval', $_POST['tiktok_pixel_events'] ) : array();

			wpcode()->settings->update_option( 'tiktok_pixel_id', $tiktok_pixel_id );
			wpcode()->settings->update_option( 'tiktok_access_token', $tiktok_access_token );
			wpcode()->settings->update_option( 'tiktok_pixel_events', $tiktok_pixel_events );
		}

		wp_safe_redirect(
			add_query_arg(
				array(
					'message' => 1,
				),
				$this->get_page_action_url()
			)
		);
		exit;
	}

	/**
	 * Override the main class get option method to actually load data in the addon.
	 *
	 * @param string $key
	 * @param mixed  $default
	 *
	 * @return mixed
	 */
	public function get_option( $key, $default = false ) {
		return wpcode()->settings->get_option( $key, $default );
	}

	/**
	 * Add a simple js check to see if the user is using an adblocker and if so
	 * display a notice that they might have trouble confirming the pixels are
	 * loaded correctly and should whitelist their site.
	 *
	 * @return void
	 */
	public function adblocker_notice_js() {
		$adex_src = WPCODE_PIXEL_PLUGIN_URL . 'assets/adex.js';
		?>
		<script src="<?php echo esc_url( $adex_src ); ?>" type="text/javascript"></script>
		<script type="text/javascript">
			const adblocker_notice = document.getElementById( 'wpcode-adblocker-notice' );
			if ( document.getElementById( 'MepWv8eL' ) ) {

			} else {
				adblocker_notice.style = 'display:block';
			}
		</script>
		<?php
	}

	/**
	 * Display a simple notice if an adblocker is detected.
	 *
	 * @return void
	 */
	public function adblocker_notice() {
		?>
		<div class="wpcode-alert wpcode-alert-warning" id="wpcode-adblocker-notice" style="display:none">
			<p><?php esc_html_e( 'It looks like you are using an ad blocker. If you are having trouble confirming your pixels are loaded correctly, please whitelist this site or disable the adblocker.', 'wpcode-pixel' ); ?></p>
		</div>
		<?php
	}

	/**
	 * Whether we have a supported eCommerce plugin installed.
	 *
	 * @return array
	 */
	public function ecommerce_available() {
		$available_providers = array();

		foreach ( wpcode_pixel()->auto_insert->providers as $provider ) {
			$available_providers[] = $provider->get_name();
		}

		return $available_providers;
	}
}
