<?php
class Loobek_WooCommerce_Extra_Products {
    protected static $instance;

	public function __construct() {
		// Backend
		add_filter('woocommerce_product_data_tabs', array($this, 'add_extra_products_tab'), 10, 1);
		add_action('woocommerce_product_data_panels', array($this, 'add_extra_products_panel'));
	
		add_action('wp_ajax_loobek_ajax_search_extra_product', array($this, 'ajax_search_extra_product'));
		add_action('wp_ajax_nopriv_loobek_ajax_search_extra_product', array($this, 'ajax_search_extra_product'));
	
		// Guardar datos del backend
		$product_types = array('simple', 'variable', 'grouped', 'external');
		foreach ($product_types as $product_type) {
			add_action('woocommerce_process_product_meta_' . $product_type, array($this, 'save_extra_products_tab'), 10, 1);
		}
	
		// Frontend
		if (!is_admin()) {
			add_action('woocommerce_before_add_to_cart_quantity', 'extra_products_html', 10);
			add_action('woocommerce_before_variations_form', 'extra_products_html', 10);
		}
		
	
		// Agregar productos al carrito
		add_action('wp_loaded', array($this, 'add_extra_products_to_cart'), 20);
	}
	
	
	

    public static function get_instance() {
        if (is_null(self::$instance)) {
            self::$instance = new self();
        }
        return self::$instance;
    }

	function extra_products_html() {
		global $product;
	
		// Verificar que el producto actual sea válido
		if (!is_singular('product') || !$product) {
			return;
		}
	
		// Recuperar los productos opcionales
		$product_ids = get_post_meta($product->get_id(), 'ts_extra_products', true);
	
		// Si no hay productos opcionales, detener
		if (empty($product_ids) || !is_array($product_ids)) {
			return;
		}
	
		// Recuperar el encabezado para la sección de productos opcionales
		$heading = get_post_meta($product->get_id(), 'ts_extra_products_heading', true);
	
		// Prevenir duplicados
		static $has_rendered = false;
		if ($has_rendered) {
			return;
		}
		$has_rendered = true;
	
		// Comenzar la salida HTML
		echo '<div class="ts-extra-products-wrapper">';
	
		// Mostrar el encabezado si existe
		if (!empty($heading)) {
			echo '<div class="heading">' . esc_html($heading) . '</div>';
		}
	
		echo '<div class="items">';
	
		// Iterar sobre cada producto opcional y mostrar su contenido
		foreach ($product_ids as $id) {
			$extra_product = wc_get_product($id);
	
			if ($extra_product && $extra_product->is_visible()) {
				echo '<div class="item">';
				echo '<div class="product-image-meta">';
				echo '<div class="image">' . $extra_product->get_image() . '</div>';
				echo '<div class="meta">';
				echo '<span>' . esc_html($extra_product->get_name()) . '</span>';
				echo $extra_product->get_price_html();
				echo '</div>'; // .meta
				echo '</div>'; // .product-image-meta
	
				echo '<label>';
				echo '<input type="checkbox" class="ts-extra-products-checkbox" value="' . esc_attr($id) . '" />';
				echo '<span data-checked="' . esc_attr__('Seleccionado', 'loobek') . '" data-unchecked="' . esc_attr__('Seleccionar', 'loobek') . '">' . esc_html__('Seleccionar', 'loobek') . '</span>';
				echo '</label>';
				echo '</div>'; // .item
			}
		}
	
		echo '</div>'; // .items
		echo '</div>'; // .ts-extra-products-wrapper
	}
	
	

    function add_extra_products_panel() {
        global $post;

        $product_id = $post->ID;
        $heading = get_post_meta($product_id, 'ts_extra_products_heading', true);
        $product_ids = get_post_meta($product_id, 'ts_extra_products', true);
        $product_ids = array_filter(array_map('absint', (array) $product_ids));
        $selected_products = array();

        foreach ($product_ids as $id) {
            $product = wc_get_product($id);
            if (is_object($product)) {
                $selected_products[$id] = html_entity_decode($product->get_formatted_name());
            }
        }
        ?>
        <div id="ts_extra_products_data_option" class="panel woocommerce_options_panel">
            <div class="options_group">
                <p class="form-field">
                    <label for="ts_extra_products_heading"><?php esc_html_e('Heading', 'loobek'); ?></label>
                    <input type="text" name="ts_extra_products_heading" id="ts_extra_products_heading" class="short" value="<?php echo esc_attr($heading); ?>" placeholder="<?php esc_attr_e('Add some accessories', 'loobek'); ?>" />
                </p>
                <p class="form-field">
                    <label for="ts_extra_products"><?php esc_html_e('Select products', 'loobek'); ?></label>
                    <select
                        id="ts_extra_products"
                        class="wc-product-search"
                        name="ts_extra_products[]"
                        data-placeholder="<?php esc_attr_e('Search for products', 'loobek'); ?>"
                        data-allow_clear="false"
                        data-action="loobek_ajax_search_extra_product"
                        multiple="multiple"
                        style="width: 50%;"
                    >
                        <?php foreach ($selected_products as $id => $name) { ?>
                            <option value="<?php echo esc_attr($id); ?>" selected="selected">
                                <?php echo esc_html($name); ?>
                            </option>
                        <?php } ?>
                    </select>
                </p>
            </div>
        </div>
        <?php
    }

    function ajax_search_extra_product() {
        $term = isset($_GET['term']) ? wc_clean(stripslashes($_GET['term'])) : '';

        if (empty($term)) {
            wp_send_json(array());
        }

        $args = array(
            'post_type'      => 'product',
            'post_status'    => 'publish',
            'posts_per_page' => -1,
            's'              => $term,
            'fields'         => 'ids'
        );

        $posts = get_posts($args);
        $products = array();

        foreach ($posts as $post_id) {
            $product = wc_get_product($post_id);
            if (is_object($product)) {
                $products[$post_id] = $product->get_formatted_name();
            }
        }

        wp_send_json($products);
    }

    function save_extra_products_tab($post_id) {
        if (isset($_POST['ts_extra_products_heading'])) {
            update_post_meta($post_id, 'ts_extra_products_heading', sanitize_text_field($_POST['ts_extra_products_heading']));
        } else {
            delete_post_meta($post_id, 'ts_extra_products_heading');
        }

        if (isset($_POST['ts_extra_products'])) {
            $product_ids = array_map('absint', $_POST['ts_extra_products']);
            update_post_meta($post_id, 'ts_extra_products', $product_ids);
        } else {
            delete_post_meta($post_id, 'ts_extra_products');
        }
    }

    function add_extra_products_to_cart() {
        if (empty($_POST['ts-extra-products'])) {
            return;
        }

        $product_ids = array_map('absint', explode(',', sanitize_text_field($_POST['ts-extra-products'])));

        foreach ($product_ids as $id) {
            WC()->cart->add_to_cart($id);
        }
    }
}

Loobek_WooCommerce_Extra_Products::get_instance();
