<?php

namespace GtmEcommerceWooPro\Lib\Service;

/**
 * Logic to handle embedding Gtm Snippet
 */
class GtmSnippetService extends \GtmEcommerceWoo\Lib\Service\GtmSnippetService {

	public function initialize() {
		parent::initialize();
		$this->initializeUserId();
	}

	private function initializeUserId() {
		$isPluginDisabled = (bool) $this->wpSettingsUtil->getOption('disabled');

		if (true === $isPluginDisabled) {
			return;
		}

		$isUserTrackingEnabled = (bool) $this->wpSettingsUtil->getOption('track_user_id');

		if (false === $isUserTrackingEnabled) {
			return;
		}

		add_action( 'wp_head', [$this, 'pushUserId'], self::PRIORITY_BEFORE_GTM );
	}

	public function pushUserId() {
		$userId = get_current_user_id();

		if (0 === $userId) {
			return;
		}

		echo sprintf(
			"<script>var dataLayer = dataLayer || [];dataLayer.push({\"event\":\"user_id\",\"user_id\":\"%s\"});</script>\n",
			(int) $userId
		);
	}
}
