<?php

class WPCode_Pixel_Server_Pinterest extends WPCode_Pixel_Server {

	public $api_url = 'https://api.pinterest.com';

	public static $API_VERSION = 'v5';

	/**
	 * This is called before an event is sent in order to add
	 * any additional data to the event.
	 *
	 * @param array $data
	 *
	 * @return array
	 */
	public function prepare_event( $data ) {

		$data = array(
			'data' => array( $data ),
		);

		return wp_json_encode( $data );
	}

	/**
	 * Get the Pinterest-specific api url.
	 *
	 * @return string
	 */
	public function get_api_url() {
		return $this->api_url . '/' . self::$API_VERSION . '/ad_accounts/' . $this->pixel_id . '/events/';
	}

	/**
	 * Add authorization header using the api token.
	 *
	 * @return string[]
	 */
	public function get_headers() {
		return array(
			'Authorization' => 'Bearer ' . $this->api_token,
			'Content-Type'  => 'application/json; charset=utf-8'
		);
	}
}
